;    Filename:	  00Pompe111113.asm   avec comparateurs et Vref = 2.5Vet attente 10s au dmarrage
;Controle de pompe immerge avec 3 electrodes
	ERRORLEVEL	-302, -301
	list      p=16F628A           ; list directive to define processor
	#include <p16F628A.inc>         ; processor specific variable definitions
;Sans quartz, release, MCLR pin4 relie en interne
	__CONFIG   _CP_OFF & _WDT_OFF& _PWRTE_ON  &_LVP_OFF & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF 
 
;Avec quartz, debug, MCLRE pin4 sous controle de LCD3   relier au +5V avec 10kohms OBLIGATOIRE!

;	__CONFIG   _CP_OFF & _WDT_OFF& _PWRTE_OFF  &_LVP_OFF & _XT_OSC &_MCLRE_ON  
 
		#DEFINE	HTHUM	      CMCON,7		;sortie du comparateur 2, 1 si humide, b7 de CMCON
		#DEFINE	BASHUM	CMCON,6		;sortie du comparateur 1, 1 si humide, b6 de CMCON
		#DEFINE	OUT		PORTB,0		;pin6  , sortie vers bobine relais via transistor
	cblock	h'20'
	TMP		;pour comptage de Wait	
	TMP1
	endc		
;**********************************************************************
START	ORG    0             	; MEM FLASH (2K)
	goto	Main			
Main
  	call		INIT			;Initialiser les IO
waitoff
  	bcf		OUT		;arrter de pomper
  	btfss	HTHUM		; 1 si humide, donc pomper
	goto	waitoff		;sec, ne rien faire
waiton
	bsf		OUT		;on pompe
	btfss	BASHUM	;1 si humide, on continue a pomper
	goto	waitoff		;sec arrter
	goto	waiton		;humide continuer  pomper
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;     
INIT				;SUB d'initialisations
	movlw		b'00000001'	;comparateurs C1 et C2 configurs sans inversion, 
	movwf 		CMCON		;
		
	banksel		VRCON		;bk1 OK pour TRI
	movlw		b'11101100'		;Vref activ, connecte  RA2 (pin1) petite plage,12, soit 2.5V
	movwf		VRCON	
	
	bcf			TRISB,0	;output pin 6
	
	bsf			TRISA,0	; input pin17 niveau BAS
	bsf			TRISA,1	;input pin 18 niveau HAUT
	
	bsf			TRISA,2	;Indispensable  input  pour VREF pin 1 connecte en interne
	banksel		0
	bcf			OUT
	movlw	d'100'
	call	WAIT_ws10s		;le temps que les capa sur Ht et Bas se chargent  plus de 2.5v
	return   
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;  
WAIT_1ms					;SUB d'attente 1 ms
	movlw	d'250'			;attendre 1ms = 250X4mus
	addlw	-1		                                              
	btfss	STATUS,Z	                                               
	goto	$-2                                            
	return	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
WAIT_wms			;SUB attente w ms 0-250ms
	movwf	tmp
	call		wait_1ms
	decfsz	TMP,f
	goto	$-2
	return
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
WAIT_100ms				;SUB d'attente de 100ms
	movlw	d'100'
	call		WAIT_wms	
	return
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
WAIT_ws10s					;SUB d'attente de w/10 s
	movwf	tmp1
	call	WAIT_100ms
	decfsz	tmp1,f
	goto	$-2
	clrwdt
	return
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
  	END                    	; directive 'end of program':::::::::::::


	


